/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.uicontrols;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class VWIconButton
extends JButton
implements MouseListener {
    private static final Border BORDER_MARGIN = BorderFactory.createEmptyBorder(2, 2, 2, 2);
    private static final Border BORDER_NORMAL = new CompoundBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), BORDER_MARGIN);
    private static final Border BORDER_HOVER = new CompoundBorder(BorderFactory.createLineBorder(new Color(11448498)), BORDER_MARGIN);
    private static final Color BGCOLOR_PRESSED = new Color(0xDDDDDD);

    public VWIconButton(String text, String imageFile) {
        super(text);
        this.setToolTipText(text);
        this.loadIcons(imageFile);
        this.setBorderPainted(true);
        this.setContentAreaFilled(false);
        this.setBorder(BORDER_NORMAL);
        this.setIconTextGap(0);
        this.addMouseListener(this);
    }

    public void paint(Graphics g) {
        Color oldColor = g.getColor();
        Dimension size = this.getSize();
        if (this.model.isArmed() && this.model.isPressed()) {
            g.setColor(BGCOLOR_PRESSED);
            g.fillRect(1, 1, size.width - 1, size.height - 1);
        }
        super.paint(g);
        g.setColor(oldColor);
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
        Object source = event.getSource();
        if (source.equals(this) && BORDER_HOVER != null) {
            this.setBorder(BORDER_HOVER);
        }
    }

    public void mouseExited(MouseEvent event) {
        Object source = event.getSource();
        if (source.equals(this) && BORDER_NORMAL != null) {
            this.setBorder(BORDER_NORMAL);
        }
    }

    public void mousePressed(MouseEvent event) {
    }

    public void mouseReleased(MouseEvent event) {
        Object source = event.getSource();
        if (source.equals(this) && BORDER_NORMAL != null) {
            this.setBorder(BORDER_NORMAL);
        }
    }

    protected void loadIcons(String imageFile) {
        try {
            String imageName;
            if (imageFile == null) {
                return;
            }
            ImageIcon icon = VWImageLoader.createImageIconNoMessage(imageFile);
            if (icon != null) {
                this.setIcon(icon);
            }
            if ((icon = VWImageLoader.createImageIconNoMessage(imageName = imageFile.substring(0, imageFile.indexOf(".gif")) + "_p.gif")) != null) {
                this.setSelectedIcon(icon);
            }
            if ((icon = VWImageLoader.createImageIconNoMessage(imageName = imageFile.substring(0, imageFile.indexOf(".gif")) + "_p.gif")) != null) {
                this.setPressedIcon(icon);
            }
            if ((icon = VWImageLoader.createImageIconNoMessage(imageName = imageFile.substring(0, imageFile.indexOf(".gif")) + "_d.gif")) != null) {
                this.setDisabledIcon(icon);
            }
            if ((icon = VWImageLoader.createImageIconNoMessage(imageName = imageFile.substring(0, imageFile.indexOf(".gif")) + "_h.gif")) != null) {
                this.setRolloverIcon(icon);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

